from django.http import JsonResponse
from django.utils.deprecation import MiddlewareMixin
from users.models import SecureUser
from users.core import TokenForge, SecretVault

class ShieldBearer(MiddlewareMixin):
    def process_request(self, request):
        if request.path in ['/api/register', '/api/login', '/api/forgot-password']:
            return None
            
        auth_header = request.headers.get('Authorization', '')
        
        if not auth_header.startswith('Bearer '):
            return JsonResponse(
                {'error': 'Missing or invalid authorization'}, 
                status=401
            )
            
        token = auth_header[7:]
        token_data, valid = TokenForge(SecretVault()).decode_token(token)
        
        if not valid:
            return JsonResponse(
                {'error': 'Invalid or expired token'},
                status=401
            )
            
        try:
            request.secure_user = SecureUser.objects.get(
                id=token_data['sub'],
                is_active=True
            )
        except SecureUser.DoesNotExist:
            return JsonResponse(
                {'error': 'User not found'},
                status=401
            )
            
        return None